<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function country()
	{
		return $this->belongsTo('Location');
	}

	public function city()
	{
		return $this->belongsTo('Location');
	}

	public function region()
	{
		return $this->belongsTo('Location');
	}

	public function fininshingStatus()
	{
		return $this->belongsTo('Lookup');
	}

	public function developer()
	{
		return $this->belongsTo('Developer');
	}

	public function units()
	{
		return $this->hasMany('Unit');
	}

	public function currency()
	{
		return $this->belongsTo('Currencies');
	}

}