<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Developer extends Model 
{

    protected $table = 'developers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function projects()
    {
        return $this->hasMany('Project');
    }

    public function developer()
    {
        return $this->belongsTo('User');
    }

    public function country()
    {
        return $this->belongsTo('Location');
    }

    public function city()
    {
        return $this->belongsTo('Location');
    }

    public function region()
    {
        return $this->belongsTo('Location');
    }

}