<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unit extends Model 
{

    protected $table = 'units';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function project()
    {
        return $this->belongsTo('Project');
    }

    public function buildingNumber()
    {
        return $this->belongsTo('Lookup');
    }

    public function position()
    {
        return $this->belongsTo('Lookup');
    }

    public function view()
    {
        return $this->belongsTo('Lookup');
    }

    public function bedroomNumber()
    {
        return $this->belongsTo('Lookup');
    }

    public function bahtroomNumber()
    {
        return $this->belongsTo('Lookup');
    }

    public function floorNumber()
    {
        return $this->belongsTo('Lookup');
    }

    public function purpose()
    {
        return $this->belongsTo('Lookup');
    }

    public function purposeType()
    {
        return $this->belongsTo('Lookup');
    }

    public function offeringType()
    {
        return $this->belongsTo('Lookup');
    }

    public function areaUnit()
    {
        return $this->belongsTo('Lookup');
    }

    public function unitType()
    {
        return $this->belongsTo('Lookup');
    }

    public function furnishingStatus()
    {
        return $this->belongsTo('Lookup');
    }

    public function fininshingStatus()
    {
        return $this->belongsTo('Lookup');
    }

    public function designType()
    {
        return $this->belongsTo('\Lookup');
    }

    public function country()
    {
        return $this->belongsTo('Location');
    }

    public function city()
    {
        return $this->belongsTo('Location');
    }

    public function reion()
    {
        return $this->belongsTo('Location');
    }

    public function paymentMethod()
    {
        return $this->belongsTo('Lookup');
    }

    public function buyer()
    {
        return $this->belongsTo('User');
    }

    public function currency()
    {
        return $this->belongsTo('Currencies');
    }

}