<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function subscripe()
    {
        return $this->hasMany('Subscription');
    }

    public function organizations()
    {
        return $this->belongsToMany('Organization');
    }

    public function testimonials()
    {
        return $this->hasMany('Testimonial');
    }

    public function messages()
    {
        return $this->hasMany('Message');
    }

    public function favorites()
    {
        return $this->hasMany('Favorite');
    }

}