<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('meta_title_en');
			$table->string('meta_title_ar');
			$table->longText('description_en');
			$table->longText('description_ar');
			$table->text('meta_descriotion_en');
			$table->text('meta_descriotion_ar');
			$table->boolean('is_featured')->default(false);
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->boolean('seo_index');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}