<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parent_id')->unsigned();
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('slug');
			$table->boolean('is_active')->default(true);
			$table->integer('order');
			$table->string('code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}