<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug')->unique();
			$table->integer('project_number')->unique();
			$table->string('title_en');
			$table->string('title_ar');
			$table->longText('description_en');
			$table->longText('description_ar');
			$table->date('delivery_date');
			$table->integer('finishing_status_id')->unsigned();
			$table->integer('developer_id')->unsigned();
			$table->integer('area_from');
			$table->integer('area_to');
			$table->integer('price_from');
			$table->integer('price_to');
			$table->integer('down_payment_from');
			$table->string('down_payment_to');
			$table->integer('number_of_installments_from');
			$table->integer('number_of_installments_to');
			$table->integer('country_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->date('fininshing_date');
			$table->integer('city_id')->unsigned();
			$table->boolean('seo_index')->default(true);
			$table->string('longitude');
			$table->string('latitude');
			$table->boolean('is_featured')->default(true);
			$table->integer('currency_id')->unsigned();
			$table->integer('number_blocks');
			$table->enum('moderation_status', array('new', 'pending', 'approved', 'published', 'rejected'));
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}