<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Section extends Eloquent {

	protected $table = 'sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function book()
	{
		return $this->belongsTo('App\Models\Book');
	}

	public function sources()
	{
		return $this->hasMany('App\Models\Resource');
	}

	public function knowledges()
	{
		return $this->hasMany('App\Models\Knowledge');
	}

}