<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerReturnsTable extends Migration {

	public function up()
	{
		Schema::create('customer_returns', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_id');
			$table->string('name', 255);
			$table->string('phone', 255);
			$table->string('order_number', 255);
			$table->integer('number_of_packages');
			$table->string('acknowledgement_number', 255);
			$table->integer('sealed_packages');
			$table->integer('items');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('customer_returns');
	}
}