<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionPackageTable extends Migration {

	public function up()
	{
		Schema::create('Subscription_package', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('name', array('golden', 'sliver'))->nullable();
			$table->integer('number_of_ads');
			$table->integer('number_of_product');
			$table->double('price');
			$table->enum('period', array('monthly', 'yearly', '..'));
		});
	}

	public function down()
	{
		Schema::drop('Subscription_package');
	}
}