<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('supplier_info', function(Blueprint $table) {
			$table->foreign('governorate_id')->references('id')->on('governorates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('supplier_info', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('governorate_id')->references('id')->on('governorates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('Material_id')->references('id')->on('Materials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('Colors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_size', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_size', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('Sizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Subscription', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Supplier_location', function(Blueprint $table) {
			$table->foreign('supplier_info_id')->references('id')->on('supplier_info')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_supplier', function(Blueprint $table) {
			$table->foreign('supplier_info_id')->references('id')->on('supplier_info')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_supplier', function(Blueprint $table) {
			$table->foreign('supplier_categories_id')->references('id')->on('supplier_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('supplier_info', function(Blueprint $table) {
			$table->dropForeign('supplier_info_governorate_id_foreign');
		});
		Schema::table('supplier_info', function(Blueprint $table) {
			$table->dropForeign('supplier_info_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_governorate_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_category_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_Material_id_foreign');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->dropForeign('color_product_product_id_foreign');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->dropForeign('color_product_color_id_foreign');
		});
		Schema::table('Product_size', function(Blueprint $table) {
			$table->dropForeign('Product_size_product_id_foreign');
		});
		Schema::table('Product_size', function(Blueprint $table) {
			$table->dropForeign('Product_size_size_id_foreign');
		});
		Schema::table('Subscription', function(Blueprint $table) {
			$table->dropForeign('Subscription_user_id_foreign');
		});
		Schema::table('Supplier_location', function(Blueprint $table) {
			$table->dropForeign('Supplier_location_supplier_info_id_foreign');
		});
		Schema::table('category_supplier', function(Blueprint $table) {
			$table->dropForeign('category_supplier_supplier_info_id_foreign');
		});
		Schema::table('category_supplier', function(Blueprint $table) {
			$table->dropForeign('category_supplier_supplier_categories_id_foreign');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->dropForeign('wishlists_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
	}
}