<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('Subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->double('amount_paid');
			$table->enum('payment_method', array('instapay', '..'));
			$table->text('notes');
			$table->enum('status', array('active', 'inactive'));
			$table->bigInteger('user_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
		});
	}

	public function down()
	{
		Schema::drop('Subscription');
	}
}