<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePATIENTSTable extends Migration {

	public function up()
	{
		Schema::create('PATIENTS', function(Blueprint $table) {
			$table->bigIncrements('ID');
			$table->string('FIRST_NAME', 32);
			$table->string('LAST_NAME', 32);
			$table->string('PHONE', 32)->nullable();
			$table->string('ADDRESS', 255)->nullable();
			$table->binary('PHOTO');
			$table->string('EMAIL', 60)->unique();
			$table->string('PASSWORD', 60);
			$table->tinyInteger('IS_ACTIVATED')->default('0');
			$table->string('remember_token', 100);
		});
	}

	public function down()
	{
		Schema::drop('PATIENTS');
	}
}