<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('DOCTORS', function(Blueprint $table) {
			$table->foreign('STAFF_ID')->references('ID')->on('STAFF')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('LABORATORIES', function(Blueprint $table) {
			$table->foreign('STAFF_ID')->references('ID')->on('STAFF')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('BOOKINGS', function(Blueprint $table) {
			$table->foreign('DOCTOR_ID')->references('ID')->on('DOCTORS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('BOOKINGS', function(Blueprint $table) {
			$table->foreign('PATIENT_ID')->references('ID')->on('PATIENTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('MEDICALS_RECORDS', function(Blueprint $table) {
			$table->foreign('DOCTOR_ID')->references('ID')->on('DOCTORS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('MEDICALS_RECORDS', function(Blueprint $table) {
			$table->foreign('PATIENT_ID')->references('ID')->on('PATIENTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('NAMES_OF_ANALYZES', function(Blueprint $table) {
			$table->foreign('LABORATORY_ID')->references('ID')->on('LABORATORIES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('NAMES_OF_TREATMENTS', function(Blueprint $table) {
			$table->foreign('DOCTOR_ID')->references('ID')->on('DOCTORS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('REQUIRED_ANALYZES', function(Blueprint $table) {
			$table->foreign('ANALYSIS_ID')->references('ID')->on('NAMES_OF_ANALYZES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('REQUIRED_ANALYZES', function(Blueprint $table) {
			$table->foreign('MEDICAL_RECORD_ID')->references('ID')->on('MEDICALS_RECORDS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('REQUIRED_ANALYZES', function(Blueprint $table) {
			$table->foreign('LABORATORY_ID')->references('ID')->on('LABORATORIES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('REQUIRED_TREATMENTS', function(Blueprint $table) {
			$table->foreign('TREATMENT_ID')->references('ID')->on('NAMES_OF_TREATMENTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('REQUIRED_TREATMENTS', function(Blueprint $table) {
			$table->foreign('MEDICAL_RECORD_ID')->references('ID')->on('MEDICALS_RECORDS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('TYPES_OF_DISEASES', function(Blueprint $table) {
			$table->foreign('DOCTOR_ID')->references('ID')->on('DOCTORS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('PERIODS_WORKS_DR', function(Blueprint $table) {
			$table->foreign('DOCTOR_ID')->references('ID')->on('DOCTORS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('POSITIVE_DISEASES', function(Blueprint $table) {
			$table->foreign('DISEASE_ID')->references('ID')->on('TYPES_OF_DISEASES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('POSITIVE_DISEASES', function(Blueprint $table) {
			$table->foreign('MEDICAL_RECORD_ID')->references('ID')->on('MEDICALS_RECORDS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('PATIENTS_ACTIVATION', function(Blueprint $table) {
			$table->foreign('PATIENT_ID')->references('ID')->on('PATIENTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('DOCTORS', function(Blueprint $table) {
			$table->dropForeign('DOCTORS_STAFF_ID_foreign');
		});
		Schema::table('LABORATORIES', function(Blueprint $table) {
			$table->dropForeign('LABORATORIES_STAFF_ID_foreign');
		});
		Schema::table('BOOKINGS', function(Blueprint $table) {
			$table->dropForeign('BOOKINGS_DOCTOR_ID_foreign');
		});
		Schema::table('BOOKINGS', function(Blueprint $table) {
			$table->dropForeign('BOOKINGS_PATIENT_ID_foreign');
		});
		Schema::table('MEDICALS_RECORDS', function(Blueprint $table) {
			$table->dropForeign('MEDICALS_RECORDS_DOCTOR_ID_foreign');
		});
		Schema::table('MEDICALS_RECORDS', function(Blueprint $table) {
			$table->dropForeign('MEDICALS_RECORDS_PATIENT_ID_foreign');
		});
		Schema::table('NAMES_OF_ANALYZES', function(Blueprint $table) {
			$table->dropForeign('NAMES_OF_ANALYZES_LABORATORY_ID_foreign');
		});
		Schema::table('NAMES_OF_TREATMENTS', function(Blueprint $table) {
			$table->dropForeign('NAMES_OF_TREATMENTS_DOCTOR_ID_foreign');
		});
		Schema::table('REQUIRED_ANALYZES', function(Blueprint $table) {
			$table->dropForeign('REQUIRED_ANALYZES_ANALYSIS_ID_foreign');
		});
		Schema::table('REQUIRED_ANALYZES', function(Blueprint $table) {
			$table->dropForeign('REQUIRED_ANALYZES_MEDICAL_RECORD_ID_foreign');
		});
		Schema::table('REQUIRED_ANALYZES', function(Blueprint $table) {
			$table->dropForeign('REQUIRED_ANALYZES_LABORATORY_ID_foreign');
		});
		Schema::table('REQUIRED_TREATMENTS', function(Blueprint $table) {
			$table->dropForeign('REQUIRED_TREATMENTS_TREATMENT_ID_foreign');
		});
		Schema::table('REQUIRED_TREATMENTS', function(Blueprint $table) {
			$table->dropForeign('REQUIRED_TREATMENTS_MEDICAL_RECORD_ID_foreign');
		});
		Schema::table('TYPES_OF_DISEASES', function(Blueprint $table) {
			$table->dropForeign('TYPES_OF_DISEASES_DOCTOR_ID_foreign');
		});
		Schema::table('PERIODS_WORKS_DR', function(Blueprint $table) {
			$table->dropForeign('PERIODS_WORKS_DR_DOCTOR_ID_foreign');
		});
		Schema::table('POSITIVE_DISEASES', function(Blueprint $table) {
			$table->dropForeign('POSITIVE_DISEASES_DISEASE_ID_foreign');
		});
		Schema::table('POSITIVE_DISEASES', function(Blueprint $table) {
			$table->dropForeign('POSITIVE_DISEASES_MEDICAL_RECORD_ID_foreign');
		});
		Schema::table('PATIENTS_ACTIVATION', function(Blueprint $table) {
			$table->dropForeign('PATIENTS_ACTIVATION_PATIENT_ID_foreign');
		});
	}
}