<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyAgencyInfoTable extends Migration {

	public function up()
	{
		Schema::create('company_agency_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_agency_id')->unsigned();
			$table->text('company_agency_description')->nullable()->index();
			$table->char('year_of_establishment', 4)->nullable()->index();
			$table->tinyInteger('status')->index()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('company_agency_info');
	}
}