<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('job_posting', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_contact_info', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_posting_details', function(Blueprint $table) {
			$table->foreign('job_posting_id')->references('id')->on('job_posting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_agency_info', function(Blueprint $table) {
			$table->foreign('company_agency_id')->references('id')->on('company_agency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_agency_contacts_info', function(Blueprint $table) {
			$table->foreign('company_agency_id')->references('id')->on('company_agency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_company_agency_chats', function(Blueprint $table) {
			$table->foreign('job_posting_id')->references('id')->on('job_posting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_company_agency_chats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_job_application', function(Blueprint $table) {
			$table->foreign('job_posting_id')->references('id')->on('job_posting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_job_application', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('job_posting', function(Blueprint $table) {
			$table->dropForeign('job_posting_user_id_foreign');
		});
		Schema::table('users_contact_info', function(Blueprint $table) {
			$table->dropForeign('users_contact_info_user_id_foreign');
		});
		Schema::table('job_posting_details', function(Blueprint $table) {
			$table->dropForeign('job_posting_details_job_posting_id_foreign');
		});
		Schema::table('company_agency_info', function(Blueprint $table) {
			$table->dropForeign('company_agency_info_company_agency_id_foreign');
		});
		Schema::table('company_agency_contacts_info', function(Blueprint $table) {
			$table->dropForeign('company_agency_contacts_info_company_agency_id_foreign');
		});
		Schema::table('user_company_agency_chats', function(Blueprint $table) {
			$table->dropForeign('user_company_agency_chats_job_posting_id_foreign');
		});
		Schema::table('user_company_agency_chats', function(Blueprint $table) {
			$table->dropForeign('user_company_agency_chats_user_id_foreign');
		});
		Schema::table('users_job_application', function(Blueprint $table) {
			$table->dropForeign('users_job_application_job_posting_id_foreign');
		});
		Schema::table('users_job_application', function(Blueprint $table) {
			$table->dropForeign('users_job_application_user_id_foreign');
		});
		Schema::table('users_profile', function(Blueprint $table) {
			$table->dropForeign('users_profile_user_id_foreign');
		});
	}
}