<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersProfileTable extends Migration {

	public function up()
	{
		Schema::create('users_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->date('dob')->nullable()->index();
			$table->float('total_experience')->nullable()->index();
			$table->mediumText('expertise')->nullable()->index();
			$table->mediumText('about_me')->nullable()->index();
			$table->text('description')->nullable()->index();
			$table->string('cv_upload_path', 255)->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users_profile');
	}
}