<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('edit_proposals', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('edit_proposals', function(Blueprint $table) {
			$table->foreign('quote_id')->references('id')->on('quotes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('edit_proposals', function(Blueprint $table) {
			$table->dropForeign('edit_proposals_user_id_foreign');
		});
		Schema::table('edit_proposals', function(Blueprint $table) {
			$table->dropForeign('edit_proposals_quote_id_foreign');
		});
	}
}