<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWatchlistsTable extends Migration {

	public function up()
	{
		Schema::create('watchlists', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('movie_id');
			$table->integer('user_id');
			$table->boolean('is_watched')->default(false);
			$table->boolean('is_favorited')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('watchlists');
	}
}