<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Phase extends Eloquent {

	protected $table = 'phase';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'title', 'notes', 'user_id', 'time');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function scenarios()
	{
		return $this->hasMany('Scenario', 'phase_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}