<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->index();
			$table->string('email', 55)->index();
			$table->string('number', 100);
			$table->string('code', 50);
			$table->enum('type', array('user', 'coach'));
			$table->string('experince', 200);
			$table->string('topics', 200);
			$table->string('fees');
			$table->string('about', 200)->nullable();
			$table->string('school')->nullable();
			$table->enum('gender', array('male', 'female', 'another'))->nullable();
			$table->string('work', 200)->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->string('address', 200)->nullable();
			$table->boolean('receive_notification')->default(1);
			$table->boolean('appear_in_search')->default(1);
			$table->boolean('keep_me_posted')->default(1);
			$table->boolean('deactivated')->default(0);
			$table->boolean('locked_my_profile')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}