<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogTable extends Migration {

	public function up()
	{
		Schema::create('log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('project_id')->unsigned();
			$table->integer('component_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->datetime('date');
			$table->integer('minutes');
			$table->text('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('log');
	}
}