<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('component_project', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('project')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('component_project', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('component')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('project')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('component')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('support', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('support', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('support', function(Blueprint $table) {
			$table->foreign('started_user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('support_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('support_user', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('support')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('project_link', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('project')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('project_deadline', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('project')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_client_id_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_user_id_foreign');
		});
		Schema::table('component_project', function(Blueprint $table) {
			$table->dropForeign('component_project_project_id_foreign');
		});
		Schema::table('component_project', function(Blueprint $table) {
			$table->dropForeign('component_project_component_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_client_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_project_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_component_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_user_id_foreign');
		});
		Schema::table('support', function(Blueprint $table) {
			$table->dropForeign('support_client_id_foreign');
		});
		Schema::table('support', function(Blueprint $table) {
			$table->dropForeign('support_user_id_foreign');
		});
		Schema::table('support', function(Blueprint $table) {
			$table->dropForeign('support_started_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('support_user', function(Blueprint $table) {
			$table->dropForeign('support_user_user_id_foreign');
		});
		Schema::table('support_user', function(Blueprint $table) {
			$table->dropForeign('support_user_support_id_foreign');
		});
		Schema::table('project_link', function(Blueprint $table) {
			$table->dropForeign('project_link_project_id_foreign');
		});
		Schema::table('project_deadline', function(Blueprint $table) {
			$table->dropForeign('project_deadline_project_id_foreign');
		});
	}
}