<?php

namespace App\Models;

class Project extends Eloquent {

	protected $table = 'project';
	public $timestamps = true;

	public function client()
	{
		return $this->belongsTo('App\Models\Project');
	}

	public function components()
	{
		return $this->hasMany('App\Models\Component');
	}

	public function link()
	{
		return $this->hasOne('App\Models\ProjectLink');
	}

	public function deadline()
	{
		return $this->hasOne('App\Models\ProjectDeadline');
	}

	public function leader()
	{
		return $this->belongsTo('App\Models\User');
	}

}