<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('notifier_id')->nullable();
			$table->integer('recipient_id')->nullable();
			$table->integer('post_id')->nullable();
			$table->string('reply_id')->nullable();
			$table->integer('comment_id')->nullable();
			$table->integer('page_id')->nullable();
			$table->integer('group_id')->nullable();
			$table->integer('group_chat_id')->nullable();
			$table->integer('event_id')->nullable();
			$table->integer('thread_id')->nullable();
			$table->integer('blog_id')->nullable();
			$table->integer('story_id')->nullable();
			$table->integer('seen_pop')->nullable();
			$table->string('type')->nullable();
			$table->string('type2')->nullable();
			$table->text('text')->nullable();
			$table->string('url')->nullable();
			$table->string('full_link')->nullable();
			$table->integer('seen')->nullable();
			$table->integer('sent_push')->nullable();
			$table->integer('admin')->nullable();
			$table->integer('time')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}