<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->text('description');
			$table->string('category_id')->nullable();
			$table->integer('workshops_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('contract')->nullable();
			$table->integer('budget')->nullable();
			$table->datetime('execution_at')->nullable();
			$table->text('files')->nullable();
			$table->string('place')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}