<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('from_id')->nullable();
			$table->integer('group_id')->nullable();
			$table->integer('page_id')->nullable();
			$table->integer('to_id')->nullable();
			$table->text('text')->nullable();
			$table->string('media')->nullable();
			$table->string('mediaFileName')->nullable();
			$table->string('mediaFileNames')->nullable();
			$table->integer('time')->nullable();
			$table->integer('seen')->nullable();
			$table->enum('deleted_one', array('0', '1'))->nullable();
			$table->enum('deleted_two', array('0', '1'))->nullable();
			$table->integer('sent_push')->nullable();
			$table->string('notification_id')->nullable();
			$table->string('type_two')->nullable();
			$table->text('stickers');
			$table->text('product_id')->nullable();
			$table->string('lat')->nullable();
			$table->string('lng')->nullable();
			$table->integer('reply_id')->nullable();
			$table->integer('story_id')->nullable();
			$table->integer('broadcast_id')->nullable();
			$table->integer('forward')->nullable();
			$table->integer('listening')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}