<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationTable extends Migration {

	public function up()
	{
		Schema::create('Reservation', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('date')->nullable();
			$table->integer('client_id')->nullable();
			$table->string('client_name', 255);
			$table->string('client_phone', 255)->nullable();
			$table->tinyInteger('table_num')->nullable();
			$table->tinyInteger('people_num')->nullable();
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Reservation');
	}
}