<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryAddTable extends Migration {

	public function up()
	{
		Schema::create('Delivery_add', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('address', 255);
			$table->tinyInteger('area_id')->nullable();
			$table->integer('salary');
			$table->string('phone', 20)->nullable();
			$table->tinyInteger('delivery_car')->nullable();
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Delivery_add');
	}
}