<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariantMapTable extends Migration {

	public function up()
	{
		Schema::create('product_variant_map', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('product_id')->unsigned()->index();
			$table->longText('product_sub_title')->nullable();
			$table->string('product_sku')->nullable();
			$table->integer('variant_id')->unsigned()->index();
			$table->integer('variant_value_id')->unsigned();
			$table->string('quantity')->nullable();
			$table->integer('unit_id')->unsigned();
			$table->decimal('regular_price')->nullable();
			$table->enum('discount_type', array('Flat', 'Percentage', 'NoDiscount'))->nullable();
			$table->decimal('discount_value')->nullable()->default('0');
			$table->decimal('sale_price')->nullable();
			$table->bigInteger('in_stock')->default('0');
			$table->integer('tax_id')->unsigned();
			$table->longText('product_description')->nullable();
			$table->enum('status', array('Active', 'Inactive', 'Deleted'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_variant_map');
	}
}