<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderDetailsModel extends Model 
{

    protected $table = 'order_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('order_id', 'product_id', 'vendor_id', 'product_variant_map_id', 'product_details', 'supplier_details', 'price', 'total_price');
    protected $fillable = array('quantity');
    protected $visible = array('quantity');
    protected $hidden = array('vendor_id');

    public function order()
    {
        return $this->belongsTo('App\OrdersModel', 'order_id');
    }

    public function product()
    {
        return $this->belongsTo('App\ProductsModel', 'product_id');
    }

    public function productVariant()
    {
        return $this->belongsTo('App\ProductVariantMapModel', 'product_variant_map_id');
    }

}