<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderDetailsTable extends Migration {

	public function up()
	{
		Schema::create('order_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->integer('vendor_id')->unsigned();
			$table->integer('product_variant_map_id')->unsigned();
			$table->json('product_details')->nullable();
			$table->json('supplier_details')->nullable();
			$table->string('price')->nullable();
			$table->integer('quantity')->nullable();
			$table->decimal('total_price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_details');
	}
}