<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreImagesTable extends Migration {

	public function up()
	{
		Schema::create('store_images', function(Blueprint $table) {
			$table->increments('id');
			$table->string('user_id')->nullable();
			$table->string('image')->nullable();
			$table->enum('status', array('Active', 'Inactive'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('store_images');
	}
}