<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrdersModel extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('user_id', 'shipping_id', 'payment_id', 'order_total', 'total_discount', 'delivery_charge', 'total_tax', 'gross_amount', 'status', 'order_date');

	public function orderDetails()
	{
		return $this->hasMany('App\OrderDetailsModel', 'order_id');
	}

	public function shipping()
	{
		return $this->belongsTo('App\ShippingModel', 'shipping_id');
	}

	public function payment()
	{
		return $this->belongsTo('App\PaymentModel', 'payment_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

}