<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingModel extends Eloquent {

	protected $table = 'shipping';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('user_id', 'shipping_name', 'shipping_address', 'shipping_email', 'shipping_phone', 'shipping_country', 'shipping_state', 'shipping_city');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

}