<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CategoriesModel extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('parent_id', 'image', 'status');
    protected $fillable = array('category_name', 'slug');
    protected $visible = array('category_name', 'slug');

    public function products()
    {
        return $this->hasMany('App\ProductsModel');
    }

}