<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingTable extends Migration {

	public function up()
	{
		Schema::create('shipping', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('shipping_name')->nullable();
			$table->string('shipping_address')->nullable();
			$table->string('shipping_email')->nullable();
			$table->string('shipping_phone')->nullable();
			$table->integer('shipping_country')->nullable();
			$table->integer('shipping_state')->nullable();
			$table->string('shipping_city')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('shipping');
	}
}