<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandsTable extends Migration {

	public function up()
	{
		Schema::create('brands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 120);
			$table->string('url_web', 800);
			$table->string('url_image', 800);
			$table->string('contry', 200);
			$table->string('telephone', 25);
			$table->string('address', 300);
			$table->integer('zip_code');
			$table->string('city', 60);
			$table->string('state', 60);
			$table->string('url_logo', 300);
		});
	}

	public function down()
	{
		Schema::drop('brands');
	}
}