<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('id_store')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('id_brand')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('id_category')->references('id')->on('categorys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_galerys', function(Blueprint $table) {
			$table->foreign('id_product')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('id_product')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attributes', function(Blueprint $table) {
			$table->foreign('id_product')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->foreign('id_product')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->foreign('id_order')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inventorys', function(Blueprint $table) {
			$table->foreign('id_product')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_address', function(Blueprint $table) {
			$table->foreign('id_order')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_address', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assigned_stores', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assigned_stores', function(Blueprint $table) {
			$table->foreign('id_store')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_id_store_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_id_brand_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_id_category_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_id_user_foreign');
		});
		Schema::table('product_galerys', function(Blueprint $table) {
			$table->dropForeign('product_galerys_id_product_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_id_product_foreign');
		});
		Schema::table('attributes', function(Blueprint $table) {
			$table->dropForeign('attributes_id_product_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_id_user_foreign');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->dropForeign('orders_products_id_product_foreign');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->dropForeign('orders_products_id_order_foreign');
		});
		Schema::table('inventorys', function(Blueprint $table) {
			$table->dropForeign('inventorys_id_product_foreign');
		});
		Schema::table('purchase_address', function(Blueprint $table) {
			$table->dropForeign('purchase_address_id_order_foreign');
		});
		Schema::table('purchase_address', function(Blueprint $table) {
			$table->dropForeign('purchase_address_id_user_foreign');
		});
		Schema::table('assigned_stores', function(Blueprint $table) {
			$table->dropForeign('assigned_stores_id_user_foreign');
		});
		Schema::table('assigned_stores', function(Blueprint $table) {
			$table->dropForeign('assigned_stores_id_store_foreign');
		});
	}
}