<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('orderId')->index();
			$table->string('productName');
			$table->integer('count');
			$table->string('extraNote');
			$table->float('price');
			$table->string('currency');
			$table->integer('productId')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}