<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('serial')->nullable();
			$table->string('barCode')->nullable();
			$table->string('imgUrl')->nullable();
			$table->string('productLink')->nullable();
			$table->integer('webshopProductId')->nullable()->index();
			$table->integer('webshopVariantId')->nullable()->index();
			$table->integer('partnerId')->index();
			$table->integer('webshopId')->index();
			$table->json('weightDetails')->nullable();
			$table->json('dimensionDetails')->nullable();
			$table->boolean('isPackage')->default(false);
			$table->text('packageItems')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}