<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStocksLogTable extends Migration {

	public function up()
	{
		Schema::create('stocks_log', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('productId');
			$table->enum('type', array('revenue', 'sale', 'scrapping', 'partnerHasTaken'));
			$table->integer('sum');
			$table->integer('reviewerUser')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stocks_log');
	}
}