<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Device extends Eloquent {

	protected $table = 'devices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sensors()
	{
		return $this->hasMany('Sensor');
	}

	public function data()
	{
		return $this->hasManyThrough('SensorData', 'Sensor');
	}

}