<?php

namespace sip;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function admin()
    {
        return $this->hasOne('sip\Admin', 'user_id');
    }

    public function consultant()
    {
        return $this->hasOne('sip\Consultant');
    }

    public function company()
    {
        return $this->hasOne('sip\Company');
    }

    public function log()
    {
        return $this->hasMany('sip\Log');
    }

    public function insertions()
    {
        return $this->hasMany('sip\Insertion');
    }

    public function exhaustpipes()
    {
        return $this->hasMany('sip\User_ExhaustPipe');
    }

}