<?php

namespace sip;

class Insertion extends Eloquent {

	protected $table = 'insertions';
	public $timestamps = true;

	public function insertions_rows()
	{
		return $this->hasMany('sip\InsertionRow');
	}

	public function users()
	{
		return $this->belongsTo('sip\User');
	}

	public function requirement()
	{
		return $this->belongsTo('sip\Requirement');
	}

	public function expirations()
	{
		return $this->belongsTo('sip\Expiration');
	}

	public function parentInsertion()
	{
		return $this->belongsTo('sip\User', 'insertion_id');
	}

}