<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnalysesTable extends Migration {

	public function up()
	{
		Schema::create('analyses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 255);
			$table->string('name');
			$table->string('unit_of_measure');
			$table->decimal('legal_lower_limit')->nullable();
			$table->decimal('legal_upper_limit')->nullable();
			$table->string('notes', 4096)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('analyses');
	}
}