<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('exhaust_pipes', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_exhaust_pipes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_exhaust_pipes', function(Blueprint $table) {
			$table->foreign('exhaust_pipe_id')->references('id')->on('exhaust_pipes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirements_rows', function(Blueprint $table) {
			$table->foreign('requirement_id')->references('id')->on('requirements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirements_rows', function(Blueprint $table) {
			$table->foreign('analysis_id')->references('id')->on('analyses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('insertions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('insertions', function(Blueprint $table) {
			$table->foreign('requirement_id')->references('id')->on('requirements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('insertions', function(Blueprint $table) {
			$table->foreign('expiration_id')->references('id')->on('expirations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('insertions_rows', function(Blueprint $table) {
			$table->foreign('insertion_id')->references('id')->on('insertions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('insertions_rows', function(Blueprint $table) {
			$table->foreign('requirement_row_id')->references('id')->on('requirements_rows')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expirations', function(Blueprint $table) {
			$table->foreign('exhaust_pipe_id')->references('id')->on('exhaust_pipes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('exhaust_pipe_id')->references('id')->on('exhaust_pipes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_user_id_foreign');
		});
		Schema::table('consultants', function(Blueprint $table) {
			$table->dropForeign('consultants_user_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('exhaust_pipes', function(Blueprint $table) {
			$table->dropForeign('exhaust_pipes_company_id_foreign');
		});
		Schema::table('users_exhaust_pipes', function(Blueprint $table) {
			$table->dropForeign('users_exhaust_pipes_user_id_foreign');
		});
		Schema::table('users_exhaust_pipes', function(Blueprint $table) {
			$table->dropForeign('users_exhaust_pipes_exhaust_pipe_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_user_id_foreign');
		});
		Schema::table('requirements_rows', function(Blueprint $table) {
			$table->dropForeign('requirements_rows_requirement_id_foreign');
		});
		Schema::table('requirements_rows', function(Blueprint $table) {
			$table->dropForeign('requirements_rows_analysis_id_foreign');
		});
		Schema::table('insertions', function(Blueprint $table) {
			$table->dropForeign('insertions_user_id_foreign');
		});
		Schema::table('insertions', function(Blueprint $table) {
			$table->dropForeign('insertions_requirement_id_foreign');
		});
		Schema::table('insertions', function(Blueprint $table) {
			$table->dropForeign('insertions_expiration_id_foreign');
		});
		Schema::table('insertions_rows', function(Blueprint $table) {
			$table->dropForeign('insertions_rows_insertion_id_foreign');
		});
		Schema::table('insertions_rows', function(Blueprint $table) {
			$table->dropForeign('insertions_rows_requirement_row_id_foreign');
		});
		Schema::table('expirations', function(Blueprint $table) {
			$table->dropForeign('expirations_exhaust_pipe_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_exhaust_pipe_id_foreign');
		});
	}
}