<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExhaustPipesTable extends Migration {

	public function up()
	{
		Schema::create('exhaust_pipes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 255);
			$table->integer('company_id')->unsigned();
			$table->string('address', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('province', 255)->nullable();
			$table->enum('type', array('IND', 'AMD', 'ASDOM'));
			$table->date('authorization_start_date')->nullable();
			$table->date('authorization_end_date')->nullable();
			$table->enum('frequency', array('monthly', 'bimestrial', 'quarterly', 'half-yearly', 'annual'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('exhaust_pipes');
	}
}