<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('poll_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('message')->nullable();
			$table->string('image', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}