<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesDataTable extends Migration {

	public function up()
	{
		Schema::create('SalesData', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('CostCenter');
			$table->integer('Month');
			$table->integer('Year');
			$table->decimal('GrossSales')->nullable();
			$table->decimal('GrossProfit')->nullable();
			$table->decimal('BasketSize')->nullable();
			$table->decimal('BasketQty')->nullable();
			$table->decimal('SalesPriceAvg')->nullable();
			$table->integer('Transactions')->nullable();
			$table->float('ConversionRate')->nullable();
			$table->integer('CustomerCount')->nullable();
			$table->integer('SalesType')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('SalesData');
	}
}